/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.cache.model;

import java.util.Arrays;
import java.util.Objects;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.jspecify.annotations.Nullable;
import software.bernie.geckolib.animation.state.BoneSnapshot;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.RenderPassInfo;
import software.bernie.geckolib.util.MiscUtil;
import software.bernie.geckolib.util.RenderUtil;

public abstract class GeoBone {
    protected final @Nullable GeoBone parent;
    protected final String name;
    protected final GeoBone[] children;
    protected final float pivotX;
    protected final float pivotY;
    protected final float pivotZ;
    protected final float baseRotX;
    protected final float baseRotY;
    protected final float baseRotZ;
    @ApiStatus.Internal
    public @Nullable BoneSnapshot frameSnapshot = null;
    @ApiStatus.Internal
    public RenderPassInfo.BonePositionListener @Nullable [] positionListeners = null;

    protected GeoBone(@Nullable GeoBone parent, String name, GeoBone[] children, float pivotX, float pivotY, float pivotZ, float rotX, float rotY, float rotZ) {
        this.parent = parent;
        this.name = name;
        this.children = children;
        this.pivotX = pivotX;
        this.pivotY = pivotY;
        this.pivotZ = pivotZ;
        this.baseRotX = rotX;
        this.baseRotY = rotY;
        this.baseRotZ = rotZ;
    }

    public @Nullable GeoBone parent() {
        return this.parent;
    }

    public String name() {
        return this.name;
    }

    public GeoBone[] children() {
        return this.children;
    }

    public float pivotX() {
        return this.pivotX;
    }

    public float pivotY() {
        return this.pivotY;
    }

    public float pivotZ() {
        return this.pivotZ;
    }

    public float baseRotX() {
        return this.baseRotX;
    }

    public float baseRotY() {
        return this.baseRotY;
    }

    public float baseRotZ() {
        return this.baseRotZ;
    }

    public abstract <R extends GeoRenderState> void render(RenderPassInfo<R> var1, class_4587 var2, class_4588 var3, int var4, int var5, int var6);

    public void renderChildren(RenderPassInfo<?> renderPassInfo, class_4587 poseStack, class_4588 vertexConsumer, int packedLight, int packedOverlay, int renderColor) {
        if (this.frameSnapshot == null || !this.frameSnapshot.areChildrenHidden()) {
            for (GeoBone child : this.children) {
                poseStack.method_22903();
                RenderUtil.prepMatrixForBoneAndUpdateListeners(poseStack, child, renderPassInfo);
                child.render(renderPassInfo, poseStack, vertexConsumer, packedLight, packedOverlay, renderColor);
                child.renderChildren(renderPassInfo, poseStack, vertexConsumer, packedLight, packedOverlay, renderColor);
                poseStack.method_22909();
            }
        }
    }

    public <R extends GeoRenderState> void positionAndRender(RenderPassInfo<R> renderPassInfo, class_4588 vertexConsumer, int packedLight, int packedOverlay, int renderColor) {
        class_4587 poseStack = renderPassInfo.poseStack();
        poseStack.method_22903();
        RenderUtil.prepMatrixForBone(poseStack, this);
        this.updateBonePositionListeners(poseStack, renderPassInfo);
        this.render(renderPassInfo, poseStack, vertexConsumer, packedLight, packedOverlay, renderColor);
        this.renderChildren(renderPassInfo, poseStack, vertexConsumer, packedLight, packedOverlay, renderColor);
        poseStack.method_22909();
    }

    public void translateToPivotPoint(class_4587 poseStack) {
        poseStack.method_46416(this.pivotX() / 16.0f, this.pivotY() / 16.0f, this.pivotZ() / 16.0f);
    }

    public void translateAwayFromPivotPoint(class_4587 poseStack) {
        poseStack.method_46416(-this.pivotX() / 16.0f, -this.pivotY() / 16.0f, -this.pivotZ() / 16.0f);
    }

    @ApiStatus.Internal
    public void updateBonePositionListeners(class_4587 poseStack, RenderPassInfo<?> renderPassInfo) {
        if (this.positionListeners != null) {
            Matrix4f bonePose = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
            Matrix4f localPose = RenderUtil.extractPoseFromRoot((Matrix4fc)bonePose, renderPassInfo.getPreRenderMatrixState());
            Matrix4f modelPose = RenderUtil.extractPoseFromRoot((Matrix4fc)bonePose, renderPassInfo.getModelRenderMatrixState());
            class_243 position = renderPassInfo.renderState().getGeckolibData(DataTickets.POSITION);
            Matrix4f worldPose = position == null ? null : RenderUtil.addPosToMatrix(new Matrix4f((Matrix4fc)localPose), position);
            class_243 localPos = RenderUtil.renderPoseToPosition((Matrix4fc)localPose, 1.0f, 1.0f, 1.0f);
            class_243 modelPos = RenderUtil.renderPoseToPosition((Matrix4fc)modelPose, -16.0f, 16.0f, 16.0f);
            class_243 worldPos = worldPose == null ? null : RenderUtil.renderPoseToPosition((Matrix4fc)worldPose, 1.0f, 1.0f, 1.0f);
            for (int i = 0; i < this.positionListeners.length; ++i) {
                this.positionListeners[i].accept(worldPos, modelPos, localPos);
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GeoBone other = (GeoBone)obj;
        if (this.parent != other.parent) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (!(MiscUtil.areFloatsEqual(this.pivotX, other.pivotX) && MiscUtil.areFloatsEqual(this.pivotY, other.pivotY) && MiscUtil.areFloatsEqual(this.pivotZ, other.pivotZ))) {
            return false;
        }
        return Arrays.equals(this.children, other.children);
    }

    public int hashCode() {
        return Objects.hash(this.parent == null ? "" : this.parent, this.name, Arrays.hashCode(this.children), Float.valueOf(this.pivotX), Float.valueOf(this.pivotY), Float.valueOf(this.pivotZ));
    }
}

